/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPathChangeListener;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IDirectory;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractBuildPath
implements IBuildPath {
    private Set<IBuildPathChangeListener> listeners = new HashSet<IBuildPathChangeListener>();
    private Set<IBuildPath> dependencies = new LinkedHashSet<IBuildPath>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildPathChangeListener(IBuildPathChangeListener listener) {
        Set<IBuildPathChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeBuildPathChangeListener(IBuildPathChangeListener listener) {
        Set<IBuildPathChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public synchronized void addDependency(IBuildPath dependency) {
        this.dependencies.add(dependency);
    }

    public synchronized Set<IBuildPath> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public synchronized void removeDependency(IBuildPath dependency) {
        this.dependencies.remove(dependency);
    }

    public void clearDependencies() {
        this.dependencies.clear();
    }

    public synchronized IModule resolveRelativePath(IModule baseModule, IPath relativePath) {
        IPath baseModulePath = this.getResourcePath((IBuildPathResource)baseModule);
        if (baseModulePath == null) {
            return null;
        }
        if (relativePath.segmentCount() == 0) {
            return baseModule;
        }
        IPath basePath = null;
        basePath = baseModulePath.segmentCount() <= 1 ? new Path("").makeAbsolute() : baseModulePath.removeLastSegments(1);
        IPath resolvedPath = basePath.append(relativePath);
        if (resolvedPath.segmentCount() == 0) {
            return null;
        }
        IModule module = this.getModuleByPath(resolvedPath);
        if (module == null && relativePath.segments()[0].startsWith(".")) {
            return null;
        }
        if (module == null) {
            module = this.getModuleByPath(relativePath);
        }
        if (module == null) {
            for (IBuildPath currentBuildPath : this.getDependencies()) {
                module = currentBuildPath.getModuleByPath(relativePath);
                if (module == null) continue;
                return module;
            }
        }
        return module;
    }

    public List<IBuildPathResource> resolveContainerRelativePath(IModule baseModule, IPath relativePath) {
        List dirs;
        IPath baseModulePath = this.getResourcePath((IBuildPathResource)baseModule);
        if (baseModulePath == null) {
            return null;
        }
        IPath basePath = null;
        basePath = baseModulePath.segmentCount() <= 1 ? new Path("").makeAbsolute() : baseModulePath.removeLastSegments(1);
        IPath resolvedPath = basePath.append(relativePath);
        ArrayList<IBuildPathResource> result = new ArrayList<IBuildPathResource>();
        List currentBuildPathModules = this.getModulesByPath(resolvedPath);
        if (currentBuildPathModules != null) {
            result.addAll(currentBuildPathModules);
        }
        if ((dirs = this.getSubdirectoriesByPath(resolvedPath)) != null) {
            result.addAll(dirs);
        }
        if (relativePath.segmentCount() >= 1 && relativePath.segment(0).length() > 0 && relativePath.segment(0).charAt(0) == '.') {
            return result;
        }
        for (IBuildPath currentBuildPath : this.getDependencies()) {
            currentBuildPathModules = currentBuildPath.getModulesByPath(relativePath);
            if (currentBuildPathModules != null) {
                result.addAll(currentBuildPathModules);
            }
            if ((dirs = currentBuildPath.getSubdirectoriesByPath(relativePath)) == null) continue;
            result.addAll(dirs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChangedBefore(List<IModule> changed, List<IModule> removed, List<IDirectory> removedDirectories) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!workspace.isAutoBuilding()) {
            return;
        }
        LinkedHashSet<IBuildPathChangeListener> buildPathListeners = null;
        Set<IBuildPathChangeListener> set = this.listeners;
        synchronized (set) {
            buildPathListeners = new LinkedHashSet<IBuildPathChangeListener>(this.listeners);
        }
        for (IBuildPathChangeListener listener : buildPathListeners) {
            try {
                listener.changedBefore(changed, removed, removedDirectories);
            }
            catch (Throwable th) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Unable notifying build path change listener", (Throwable)th);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChangedAfter(List<IModule> added, List<IModule> changed, List<IModule> removed, List<IDirectory> addedDirectories, List<IDirectory> removedDirectories) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (!workspace.isAutoBuilding()) {
            return;
        }
        LinkedHashSet<IBuildPathChangeListener> buildPathListeners = null;
        Set<IBuildPathChangeListener> set = this.listeners;
        synchronized (set) {
            buildPathListeners = new LinkedHashSet<IBuildPathChangeListener>(this.listeners);
        }
        for (IBuildPathChangeListener listener : buildPathListeners) {
            try {
                listener.changedAfter(added, changed, removed, addedDirectories, removedDirectories);
            }
            catch (Throwable th) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Unable notifying build path change listener", (Throwable)th);
            }
        }
    }
}

